import msal

LOGIN_URL = "https://login.microsoftonline.com/"
SCOPES = ["https://graph.microsoft.com/.default"]


class MsServiceCredentials:
    def __init__(self, secret):
        self.scopes = SCOPES
        self.secret = secret

    def get_token(self, login):
        if not hasattr(self, "token"):
            self.token = self._get_token(login)
        return self.token

    def _get_token(self, login):
        domain = _domain(login)
        authority = LOGIN_URL + domain
        self.app = msal.ConfidentialClientApplication(
            self.secret["client_id"], authority=authority, client_credential=self.secret["secret"]
        )

        result = self.app.acquire_token_silent(self.scopes, account=None)
        if not result:
            result = self.app.acquire_token_for_client(scopes=self.scopes)

        if "access_token" in result:
            return result["access_token"]
        else:
            raise Exception(
                "Failed to acquire token: {} {} {}".format(
                    result.get("error"),
                    result.get("error_description"),
                    result.get("correlation_id"),
                )
            )


def _domain(email):
    return email[email.rfind("@") + 1 :]
