from google_credentials import GoogleServiceCredentials
from ms_credentials import MsServiceCredentials
from enum import Enum


class Provider(str, Enum):
    GOOGLE = "google"
    MICROSOFT = "microsoft"

    def fake_login(self):
        if self == Provider.GOOGLE:
            return "migration-meta"
        elif self == Provider.MICROSOFT:
            return "migration-meta-ms"

    def service_credentials_cls(self):
        if self == Provider.GOOGLE:
            return GoogleServiceCredentials
        elif self == Provider.MICROSOFT:
            return MsServiceCredentials

    @staticmethod
    def from_imap_server(server):
        if server == "imap.gmail.com":
            return Provider.GOOGLE
        elif server == "outlook.office365.com":
            return Provider.MICROSOFT
        else:
            raise Exception("Unknown imap server: {}".format())
