from typing import Any, Dict

import requests

import tvm
from provider import Provider
from settings import TractorSettings, settings


class TractorApi:
    def __init__(self):
        self.settings: TractorSettings = settings().tractor

    def retrieve_secret(self, org_id: str, provider: Provider) -> str:
        url: str = f"{self.settings.base_url}/organizations/{org_id}/external_secret?provider={provider.value}"
        response: requests.Response = tvm.load_url(url)
        if response.status_code == 404:
            raise RuntimeError("no secrets from api")
        response.raise_for_status()
        response_json: Dict[str, Any] = response.json()
        return response_json["external_secret"]
