from typing import Any, Dict
import json
from urllib.parse import SplitResult, urlsplit
from os import environ

import requests

_TVM_TOKEN: str = environ["QLOUD_TVM_TOKEN"]
_TVM_ORIGIN_URL: str = environ["QLOUD_TVM_INTERFACE_ORIGIN"]
assert _TVM_ORIGIN_URL.endswith("/"), _TVM_ORIGIN_URL


def load_url(url: str) -> requests.Response:
    url_parts: SplitResult = urlsplit(url)
    if url_parts.hostname is None:
        raise RuntimeError("No hostname in the URL", url)
    ticket: str = _get_service_ticket_for(url_parts.hostname)
    headers: Dict[str, Any] = {"X-Ya-Service-Ticket": ticket}
    return requests.get(url, headers=headers)


def _get_service_ticket_for(target: str):
    url: str = f"{_TVM_ORIGIN_URL}tvm/tickets?dsts={target}"
    headers: Dict[str, Any] = {"Authorization": _TVM_TOKEN}
    response: requests.Response = requests.get(url, headers=headers)
    response.raise_for_status()
    response_json: Dict[str, Any] = json.loads(response.text)
    return response_json[target]["ticket"]
