#!/usr/bin/python3
# -*- coding: UTF-8 -*-

import json
import yaml
import time
import os
from collections import defaultdict


CONFIG_FILE = "/etc/collectors-ext/config.yml"
with open(CONFIG_FILE) as file:
    CONFIG = yaml.safe_load(file)
NOW = int(time.time())


def get_provider(server):
    return CONFIG["server_to_provider_map"].get(server, "custom")


def print_signals(env_name, data_file):
    if not os.path.exists(data_file):
        return

    file_time = int(os.path.getmtime(data_file))
    if NOW - 1200 > file_time:  # check file not older than 20 min
        return

    with open(data_file, "r") as f:
        data = json.load(f)

    pop3_delays = defaultdict(list)
    imap_delays = defaultdict(list)
    for popid, info in data.items():
        delay = NOW - info["last_connect"]
        if info["protocol"] == "imap":
            imap_delays[get_provider(info["server"])].append(str(delay))
        else:
            pop3_delays[get_provider(info["server"])].append(str(delay))

    for provider, values in imap_delays.items():
        print("{}.old_collectors.total_imap {} {} {}".format(env_name, len(values), NOW, provider))
        print(
            "{}.old_collectors.imap_delays_hgram [{}] {} {}".format(
                env_name, ",".join(values), NOW, provider
            )
        )

    for provider, values in pop3_delays.items():
        print("{}.old_collectors.total_pop3 {} {} {}".format(env_name, len(values), NOW, provider))
        print(
            "{}.old_collectors.pop3_delays_hgram [{}] {} {}".format(
                env_name, ",".join(values), NOW, provider
            )
        )


for env in CONFIG["envs"]:
    data_file = "/var/collectors-ext/old_collectors_{}.json".format(env["name"])
    print_signals(env["name"], data_file)
