#pragma once

#include <api/error.h>
#include <common/config.h>
#include <common/data_source.h>
#include <ymod_imapclient/call.h>
#include <yplatform/module.h>

namespace yrpopper { namespace api {

struct server_status
{
    server_status() : ip(), msg_count(0), msg_size(0)
    {
    }

    string ip;
    std::size_t msg_count;
    std::size_t msg_size;
};

enum task_validity
{
    task_ora_ok,
    task_pq_ok,
    task_bad,
    task_temporary_error
};

typedef yplatform::future::future<server_status> future_server_status;
typedef yplatform::future::promise<server_status> promise_server_status;
typedef yplatform::future::future<bool> future_bool_t;
typedef yplatform::future::promise<bool> promise_bool_t;
typedef yplatform::future::future<task_validity> future_task_validity_t;
typedef yplatform::future::promise<task_validity> promise_task_validity_t;

class api : public yplatform::module
{
public:
    virtual future_popid_t create(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const string& login,
        const task_info& task) = 0;

    virtual future_void_t remove(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const popid_t& id) = 0;

    virtual future_popid_t edit(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const string& login,
        const task_info& task,
        bool reset_status) = 0;

    virtual future_void_t enable(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const popid_t& id,
        bool on) = 0;

    virtual future_void_t enable_abook(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const popid_t& id) = 0;

    virtual future_task_info_list list(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const popid_t& id,
        bool skipCache) = 0;

    virtual future_server_status check_server(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const string& ip,
        const task_info& task) = 0;

    virtual future_task_validity_t check_task_validity(
        const yplatform::task_context_ptr& ctx,
        const string& mdb,
        const string& suid,
        const base_task_info& task) = 0;
};

typedef boost::shared_ptr<api> api_ptr;

}}
