#pragma once

#include <common/config.h>
#include <yplatform/exception.h>

namespace yrpopper { namespace api {

class error : public yplatform::exception
{
public:
    inline error() : yplatform::exception()
    {
    }

    explicit inline error(const string& cl) : yplatform::exception(cl, string(), string())
    {
    }

    inline error(const string& cl, string const& pub) : yplatform::exception(cl, pub, string())
    {
    }

    inline error(const string& cl, string const& pub, string const& prv)
        : yplatform::exception(cl, pub, prv)
    {
    }

    virtual inline ~error()
    {
    }
};

#define YRPOPPER_API_INTERNAL_ERROR_DESC "internal error"
#define YRPOPPER_API_SYNTAX_ERROR_DESC "syntax error"
#define YRPOPPER_API_STORAGE_ERROR_DESC "storage error"
#define YRPOPPER_API_NOT_FOUND_ERROR_DESC "not found"
#define YRPOPPER_API_SSL_ERROR_DESC "ssl handshake error"
#define YRPOPPER_API_CONNECT_ERROR_DESC "connect error"
#define YRPOPPER_API_LOGIN_ERROR_DESC "login error"
#define YRPOPPER_API_PROTO_ERROR_DESC "proto error"
#define YRPOPPER_API_RESOLVE_ERROR_DESC "resolve error"
#define YRPOPPER_API_DUBLICATE_ERROR_DESC "dublicate error"
#define YRPOPPER_API_HIMSELF_ERROR_DESC "rpop from himself error"
#define YRPOPPER_API_OWNER_NULL_ERROR_DESC "rpop owner is null"
#define YRPOPPER_API_OWNER_INVALID_ERROR_DESC "rpop owner invalid format"
#define YRPOPPER_API_LIST_ERROR_DESC "list error"
#define YRPOPPER_API_ACCESS_DENIED_ERROR_DESC "access denied error"
#define YRPOPPER_API_FORBIDDEN_SERVER_ERROR_DESC "forbidden server error"
#define YRPOPPER_API_RC_ERROR_DESC "rate control error"
#define YRPOPPER_API_UNKNOWN_DOMAIN_ERROR_DESC "unknown domain error"
#define YRPOPPER_API_UNKNOWN_PROVIDER_ERROR_DESC "unknown provider error"
#define YRPOPPER_API_INCORRECT_OAUTH_DATA_ERROR_DESC "oauth data is incorrect"
#define YRPOPPER_API_COLLECTOR_NOT_STARTED_YET "collector not started yet"

struct internal_error
    : YPLATFORM_ERROR_DEF(
          internal_error,
          error,
          "internal_error",
          YRPOPPER_API_INTERNAL_ERROR_DESC);

struct storage_error
    : YPLATFORM_ERROR_DEF(storage_error, error, "storage_error", YRPOPPER_API_STORAGE_ERROR_DESC);

struct not_found_error
    : YPLATFORM_ERROR_DEF(
          not_found_error,
          error,
          "not_found_error",
          YRPOPPER_API_NOT_FOUND_ERROR_DESC);

struct ssl_handshake_error
    : YPLATFORM_ERROR_DEF(
          ssl_handshake_error,
          error,
          "ssl_handshake_error",
          YRPOPPER_API_SSL_ERROR_DESC);

struct connect_error
    : YPLATFORM_ERROR_DEF(connect_error, error, "connect_error", YRPOPPER_API_CONNECT_ERROR_DESC);

struct login_error
    : YPLATFORM_ERROR_DEF(login_error, error, "login_error", YRPOPPER_API_LOGIN_ERROR_DESC);

struct proto_error
    : YPLATFORM_ERROR_DEF(proto_error, error, "proto_error", YRPOPPER_API_PROTO_ERROR_DESC);

struct resolve_error
    : YPLATFORM_ERROR_DEF(resolve_error, error, "resolve_error", YRPOPPER_API_RESOLVE_ERROR_DESC);

struct dublicate_error
    : YPLATFORM_ERROR_DEF(
          dublicate_error,
          error,
          "dublicate_error",
          YRPOPPER_API_DUBLICATE_ERROR_DESC);

struct himself_error
    : YPLATFORM_ERROR_DEF(himself_error, error, "himself_error", YRPOPPER_API_HIMSELF_ERROR_DESC);

struct owner_null_error
    : YPLATFORM_ERROR_DEF(
          owner_null_error,
          error,
          "owner_null_error",
          YRPOPPER_API_OWNER_NULL_ERROR_DESC);

struct owner_invalid_error
    : YPLATFORM_ERROR_DEF(
          owner_invalid_error,
          error,
          "owner_invalid_error",
          YRPOPPER_API_OWNER_INVALID_ERROR_DESC);

struct list_error
    : YPLATFORM_ERROR_DEF(list_error, error, "list_error", YRPOPPER_API_LIST_ERROR_DESC);

struct access_denied_error
    : YPLATFORM_ERROR_DEF(
          access_denied_error,
          error,
          "access_denied_error",
          YRPOPPER_API_ACCESS_DENIED_ERROR_DESC);

struct forbidden_server_error
    : YPLATFORM_ERROR_DEF(
          forbidden_server_error,
          error,
          "forbidden_server_error",
          YRPOPPER_API_FORBIDDEN_SERVER_ERROR_DESC);

struct rc_email_error
    : YPLATFORM_ERROR_DEF(rc_email_error, error, "rc_email_error", YRPOPPER_API_RC_ERROR_DESC);

struct rc_ip_error
    : YPLATFORM_ERROR_DEF(rc_ip_error, error, "rc_ip_error", YRPOPPER_API_RC_ERROR_DESC);

struct unknown_domain_error
    : YPLATFORM_ERROR_DEF(
          unknown_domain_error,
          error,
          "unknown_domain_error",
          YRPOPPER_API_UNKNOWN_DOMAIN_ERROR_DESC);

struct collector_not_started_yet
    : YPLATFORM_ERROR_DEF(
          collector_not_started_yet,
          error,
          "collector_not_started_yet",
          YRPOPPER_API_COLLECTOR_NOT_STARTED_YET);

}}
