#pragma once

namespace yrpopper { namespace api { namespace http {

struct Mdb
{
};
struct Uid
{
};
struct Suid
{
};
struct User
{
};
struct Popid
{
};
struct UseJson
{
};

using StreamPtr = ymod_webserver::http::stream_ptr;

inline string get_http_param_value(StreamPtr stream, const string& name, const string& def = "")
{
    auto request = stream->request();
    auto const& params = request->url.params;
    auto it = request->url.params.find(name);
    if (it == params.end())
    {
        return def;
    }
    return it->second;
}

inline string get_http_header_value(StreamPtr stream, const string& name, const string& def = "")
{
    auto request = stream->request();
    auto it = request->headers.find(name);
    if (it == request->headers.end())
    {
        return def;
    }
    return it->second;
}

template <typename... Tail>
struct ParamsReader;

struct ApiParams
{
    template <typename... ParamsList>
    bool read(StreamPtr stream)
    {
        ParamsReader<ParamsList...> paramsReader;
        return paramsReader.read(stream, *this);
    }

    std::string mdb;
    std::string uid;
    std::string suid;
    popid_t popid = 0;
    bool use_json = false;
    std::string myLogin;
};

template <class TypeTag>
struct ParamReader
{
    bool read(StreamPtr stream, ApiParams& apiParams);
};

template <>
bool ParamReader<Mdb>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.mdb = get_http_param_value(stream, "mdb");
    return !apiParams.mdb.empty();
}

template <>
bool ParamReader<Uid>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.uid = get_http_param_value(stream, "uid");
    return true; // uid is always optional
}

template <>
bool ParamReader<Suid>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.suid = get_http_param_value(stream, "suid");
    return !apiParams.suid.empty();
}

template <>
bool ParamReader<User>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.myLogin = get_http_param_value(stream, "user");
    return !apiParams.myLogin.empty();
}

template <>
bool ParamReader<Popid>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.popid = 0;
    try
    {
        apiParams.popid = boost::lexical_cast<popid_t>(get_http_param_value(stream, "popid"));
    }
    catch (...)
    {
    }
    return apiParams.popid != 0;
}

template <>
bool ParamReader<UseJson>::read(StreamPtr stream, ApiParams& apiParams)
{
    apiParams.use_json = (get_http_param_value(stream, "json") == "1");
    return true;
}

template <typename Head, typename... Tail>
struct ParamsReader<Head, Tail...>
{

    bool read(StreamPtr stream, ApiParams& apiParams)
    {
        ParamReader<Head> headReader;
        ParamsReader<Tail...> restReader;
        return headReader.read(stream, apiParams) && restReader.read(stream, apiParams);
    }
};

template <>
struct ParamsReader<>
{
    bool read(StreamPtr, ApiParams&)
    {
        return true;
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
