#pragma once

#include <api/http/common.h>

namespace yrpopper { namespace api { namespace http {

class Enable : public HandlerImpl<VoidResult, Mdb, Suid, Popid>
{
    typedef HandlerImpl<VoidResult, Mdb, Suid, Popid> EnableHandlerBase;
    bool isOn = false;

public:
    Enable(const ApiImplPtr& api) : EnableHandlerBase(api, "enable")
    {
    }

protected:
    virtual bool checkParams()
    {
        string enableStr = get_http_param_value(stream, "is_on");
        if (enableStr.empty() || !(enableStr == "0" || enableStr == "1"))
        {
            fail_finish(YRPOPPER_API_SYNTAX_ERROR_DESC, "param 'is_on' has wrong value");
            return false;
        }
        isOn = (enableStr == "1");
        return true;
    }

    virtual FutureApiResult makeApiRequest()
    {
        return api_->enable(stream->ctx(), apiParams.mdb, apiParams.suid, apiParams.popid, isOn);
    }

    virtual void respondeJson(json_builder& json, VoidResult&)
    {
        json.begin_map()
            .value("request", request_name())
            .value("host", settings_.my_owner_name)
            .value("id", uniq_id())
            .end_map();
    }

    virtual void respondeXml(xml_builder& xml, VoidResult&)
    {
        xml.begin_node("yamail")
            .endl()
            .begin_node(request_name())
            .add_attr("host", settings_.my_owner_name)
            .add_attr("request_id", uniq_id())
            .end_node()
            .endl()
            .end_node();
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
