#pragma once

#include <api/http/common.h>

namespace yrpopper { namespace api { namespace http {

class Info : public HandlerImpl<std::string, Popid>
{
    typedef HandlerImpl<std::string, Popid> InfoHandlerBase;

public:
    Info(const ApiImplPtr& api) : InfoHandlerBase(api, "info")
    {
    }

protected:
    virtual FutureApiResult makeApiRequest()
    {
        return api_->owner(stream->ctx(), apiParams.popid);
    }

    virtual void respondeJson(json_builder& json, std::string& owner)
    {
        json.begin_map()
            .value("request", request_name())
            .value("host", settings_.my_owner_name)
            .value("id", uniq_id())
            .value("owner", owner)
            .end_map();
    }

    virtual void respondeXml(xml_builder& xml, std::string& owner)
    {
        xml.begin_node("yamail")
            .endl()
            .begin_node(request_name())
            .add_attr("host", settings_.my_owner_name)
            .add_attr("request_id", uniq_id())
            .add_attr("owner", owner)
            .endl()
            .end_node()
            .end_node();
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
