#pragma once

#include <api/http/common.h>

namespace yrpopper { namespace api { namespace http {

class PingPong : public WebserverHandlerImpl
{
public:
    PingPong(const ApiImplPtr& api) : WebserverHandlerImpl(api)
    {
    }

    bool exec()
    {
        responseText(ymod_webserver::codes::ok, "pong");
        return true;
    }

    const std::string& request_name() const override
    {
        static const std::string name = "ping";
        return name;
    };
};

} // namespace http
} // namespace api
} // namespace yrpopper
