#pragma once

#include <api/http/common.h>

namespace yrpopper { namespace api { namespace http {

class Remove : public HandlerImpl<VoidResult, Mdb, Suid, Popid>
{
    typedef HandlerImpl<VoidResult, Mdb, Suid, Popid> RemoveHandlerBase;

public:
    Remove(const ApiImplPtr& api) : RemoveHandlerBase(api, "remove")
    {
    }

protected:
    virtual FutureApiResult makeApiRequest()
    {
        return api_->remove(stream->ctx(), apiParams.mdb, apiParams.suid, apiParams.popid);
    }

    virtual void respondeJson(json_builder& json, VoidResult&)
    {
        json.begin_map()
            .value("request", request_name())
            .value("host", settings_.my_owner_name)
            .value("id", uniq_id())
            .end_map();
    }

    virtual void respondeXml(xml_builder& xml, VoidResult&)
    {
        xml.begin_node("yamail")
            .endl()
            .begin_node(request_name())
            .add_attr("host", settings_.my_owner_name)
            .add_attr("request_id", uniq_id())
            .end_node()
            .endl()
            .end_node();
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
