#pragma once

#include <api/http/common.h>

namespace yrpopper { namespace api { namespace http {

class Status : public HandlerImpl<StatusData, Popid>
{
    using StatusHandlerBase = HandlerImpl<StatusData, Popid>;

public:
    Status(const ApiImplPtr& api) : StatusHandlerBase(api, "status")
    {
    }

protected:
    virtual FutureApiResult makeApiRequest()
    {
        if (settings_.oauth_hack_settings)
        {
            return api_->hacked_status(stream->ctx(), apiParams.popid);
        }
        return api_->status(stream->ctx(), apiParams.popid);
    }

    virtual void respondeJson(json_builder& json, StatusData& status)
    {
        json.begin_map()
            .value("request", request_name())
            .value("host", settings_.my_owner_name)
            .value("id", uniq_id())
            .begin_array("folders");

        for (auto& item : status)
        {
            json.begin_map()
                .value("name", item.folderName)
                .value("messages", boost::lexical_cast<std::string>(item.messages))
                .value("collected", boost::lexical_cast<std::string>(item.collected))
                .value("errors", boost::lexical_cast<std::string>(item.errors));
            json.end_map();
        }

        json.end_array().end_map();
    }

    virtual void respondeXml(xml_builder& xml, StatusData& status)
    {
        xml.begin_node("yamail")
            .endl()
            .begin_node(request_name())
            .add_attr("host", settings_.my_owner_name)
            .add_attr("count", status.size())
            .add_attr("request_id", uniq_id())
            .endl();

        for (auto& item : status)
        {
            xml.begin_node("folder")
                .add_attr("name", item.folderName)
                .add_attr("messages", boost::lexical_cast<std::string>(item.messages))
                .add_attr("collected", boost::lexical_cast<std::string>(item.collected))
                .add_attr("errors", boost::lexical_cast<std::string>(item.errors));
            xml.end_node().endl();
        }

        xml.end_node().end_node();
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
