#pragma once

#include <api/http/v2/setup_collector.h>

namespace yrpopper { namespace api { namespace http {

class SetupLogin : public SetupCollector
{
    task_info_ptr taskInfo;
    server_param param;

    std::string email;
    std::string pass;

public:
    SetupLogin(const ApiImplPtr& api)
        : SetupCollector(api, "setup_login"), taskInfo(std::make_shared<task_info>())
    {
    }

protected:
    virtual void prepareParams()
    {
        email = get_http_param_value(stream, "email", "");
        if (email.empty())
        {
            return fail_finish(YRPOPPER_API_SYNTAX_ERROR_DESC, "can`t process request: no email");
        }

        pass = get_http_param_value(stream, "password", "");
        if (pass.empty())
        {
            return fail_finish(
                YRPOPPER_API_SYNTAX_ERROR_DESC, "can`t process request: no password");
        }
        pass = encrypt_password(pass, settings_.dkeys, apiParams.suid);

        param.recieve.server = get_http_param_value(stream, "server", "");
        param.recieve.use_ssl = (get_http_param_value(stream, "ssl", "1") == "1");

        try
        {
            param.recieve.port =
                boost::lexical_cast<unsigned>(get_http_param_value(stream, "port", "0"));
        }
        catch (...)
        {
            return fail_finish(
                YRPOPPER_API_SYNTAX_ERROR_DESC,
                "can`t process request: port has non-integer value");
        }

        if (param.recieve.server.empty() || param.recieve.port == 0)
        {
            size_t pos = email.find('@');
            if (pos == email.npos)
            {
                return fail_finish(
                    YRPOPPER_API_SYNTAX_ERROR_DESC, "can`t process request: wrong email " + email);
            }
            string domain = email.substr(pos + 1);

            auto found = settings_.predefined_settings.find(domain);
            if (found != settings_.predefined_settings.end())
            {
                param = found->second;
            }
            else
            {
                param = server_param();
            }

            if (param.recieve.server.empty())
            {
                return fail_finish(
                    YRPOPPER_API_UNKNOWN_DOMAIN_ERROR_DESC,
                    "server not found in config: " + domain + ", full server info required");
            }
        }

        setTaskParams();
        handleParams();
    }

    virtual void handleTask(const task_info& task)
    {
        taskInfo = std::make_shared<task_info>(task);
        setTaskParams();
    }

    virtual std::string getEmail()
    {
        return email;
    }

    virtual task_info_ptr getTask()
    {
        return taskInfo;
    }

private:
    void setTaskParams()
    {
        taskInfo->oauth_refresh_token = "";
        taskInfo->password = pass;
        taskInfo->login = email;
        taskInfo->email = email;

        taskInfo->server = param.recieve.server;
        taskInfo->port = param.recieve.port;
        taskInfo->use_ssl = param.recieve.use_ssl;
        taskInfo->use_imap = true;
    }
};

} // namespace http
} // namespace api
} // namespace yrpopper
