#include <api/api_impl.h>
#include <oauth/oauth.h>

namespace yrpopper::api {

void api_impl::create_oauth_helper(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    future_string res,
    create_args args)
{
    if (res.has_exception())
    {
        try
        {
            res.get();
        }
        catch (std::exception& e)
        {
            TASK_LOG(ctx, error) << "create_oauth_helper exception: " << e.what();
        }
        args->prom.set_exception(internal_error());
        return;
    }

    args->task.oauth_refresh_token = encrypt_password(res.get(), settings_->dkeys, suid);
    future_dublicate fres = check_dublicate(ctx, mdb, suid, 0, args->task.server, args->task.login);
    fres.add_callback(boost::bind(&api_impl::handle_create_check, this, args, fres));
}

future_popid_t api_impl::create(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    const std::string& login,
    const task_info& task)
{
    create_args args(new create_edit_data);
    args->ctx = ctx;
    args->mdb = mdb;
    args->suid = suid;
    args->login = login;
    args->task = task;

    future_dublicate fres = check_dublicate(ctx, mdb, suid, 0, task.server, task.login);
    fres.add_callback(boost::bind(&api_impl::handle_create_check, this, args, fres));
    return args->prom;
}

void api_impl::handle_create_check(const create_args& args, future_dublicate res)
{
    if (res.has_exception())
    {
        TASK_LOG(args->ctx, error)
            << "api_impl::handle_create_check exception: " << get_exception_reason(res);
        args->prom.set_exception(internal_error());
        return;
    }
    typedef check_dublicate_data cdd_t;
    if (res.get() != cdd_t::ok)
    {
        switch (res.get())
        {
        case cdd_t::from_himself:
            args->prom.set_exception(himself_error());
            break;
        case cdd_t::dublicate:
            args->prom.set_exception(dublicate_error());
            break;
        case cdd_t::resolve_fail:
            args->prom.set_exception(resolve_error());
            break;
        case cdd_t::list_fail:
            args->prom.set_exception(storage_error());
            break;
        case cdd_t::access_denied:
            args->prom.set_exception(access_denied_error());
            break;
        default:
            args->prom.set_exception(internal_error());
            break;
        }
        return;
    }
    auto futureCreate = dbInterface->create(args->ctx, args->suid, args->task);
    futureCreate.add_callback(boost::bind(&api_impl::handle_create_done, this, args, futureCreate));
}

void api_impl::handle_create_done(const create_args& args, future_popid_t res)
{
    if (res.has_exception())
    {
        TASK_LOG(args->ctx, error)
            << "api_impl::handle_create_done exception: " << get_exception_reason(res);
        args->prom.set_exception(storage_error());
    }
    else
    {
        handle_update(args->ctx, args->mdb, args->suid, args->task.popid);
        args->prom.set(res.get());
    }
}

} // namespace yrpopper::api
