#include <api/api_impl.h>
#include <oauth/oauth.h>

namespace yrpopper::api {

future_popid_t api_impl::edit(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    const std::string& login,
    const task_info& task,
    bool reset_status)
{
    edit_args args(new create_edit_data);
    args->ctx = ctx;
    args->mdb = mdb;
    args->suid = suid;
    args->login = login;
    args->task = task;
    args->reset_status = reset_status;

    future_dublicate fres = check_dublicate(ctx, mdb, suid, task.popid, task.server, task.login);
    fres.add_callback(boost::bind(&api_impl::handle_edit_check, this, args, fres));
    return args->prom;
}

void api_impl::edit_oauth_helper(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    future_string res,
    edit_args args)
{
    if (res.has_exception())
    {
        try
        {
            res.get();
        }
        catch (std::exception& e)
        {
            TASK_LOG(ctx, error) << "edit_oauth_helper exception: " << e.what();
        }
        args->prom.set_exception(internal_error());
        return;
    }

    args->task.oauth_refresh_token = encrypt_password(res.get(), settings_->dkeys, suid);
    future_dublicate fres =
        check_dublicate(ctx, mdb, suid, args->task.popid, args->task.server, args->task.login);
    fres.add_callback(boost::bind(&api_impl::handle_edit_check, this, args, fres));
}

void api_impl::handle_edit_check(const edit_args& args, future_dublicate res)
{
    if (res.has_exception())
    {
        TASK_LOG(args->ctx, error)
            << "api_impl::handle_edit_check exception: " << get_exception_reason(res);
        args->prom.set_exception(internal_error());
        return;
    }
    if (res.get() != check_dublicate_data::ok)
    {
        switch (res.get())
        {
        case check_dublicate_data::from_himself:
            args->prom.set_exception(himself_error());
            break;
        case check_dublicate_data::dublicate:
            args->prom.set_exception(dublicate_error());
            break;
        case check_dublicate_data::resolve_fail:
            args->prom.set_exception(resolve_error());
            break;
        case check_dublicate_data::list_fail:
            args->prom.set_exception(storage_error());
            break;
        case check_dublicate_data::access_denied:
            args->prom.set_exception(access_denied_error());
            break;
        default:
            args->prom.set_exception(internal_error());
            break;
        }
        return;
    }
    future_void_t fres = dbInterface->edit(args->ctx, args->suid, args->task);
    fres.add_callback(boost::bind(&api_impl::handle_edit_done, this, args, fres));
}

void api_impl::handle_edit_done(const edit_args& args, future_void_t res)
{
    if (res.has_exception())
    {
        TASK_LOG(args->ctx, error)
            << "api_impl::handle_edit_done exception: " << get_exception_reason(res);
        args->prom.set_exception(storage_error());
    }
    else
    {
        if (args->reset_status)
        {
            auto fres = dbInterface->resetStatus(args->ctx, args->suid, args->task);
            fres.add_callback([fres, args, this]() {
                if (fres.has_exception())
                {
                    TASK_LOG(args->ctx, error) << "error reset task status after edit, reason: "
                                               << get_exception_reason(fres);
                }
                handle_update(args->ctx, args->mdb, args->suid, args->task.popid);
                args->prom.set(args->task.popid);
            });
        }
        else
        {
            handle_update(args->ctx, args->mdb, args->suid, args->task.popid);
            args->prom.set(args->task.popid);
        }
    }
}

} // namespace yrpopper::api
