#include <api/api_impl.h>
#include <scheduler/scheduler.h>

#include <yplatform/find.h>

namespace yrpopper::api {

future_void_t api_impl::enable(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    const popid_t& id,
    bool on)
{
    promise_void_t prom;
    future_void_t fres = dbInterface->enableCollector(ctx, suid, id, on);
    auto enableCallback =
        boost::bind(&api_impl::handle_enable_done, this, ctx, fres, prom, mdb, suid, id);
    fres.add_callback(enableCallback);
    return prom;
}

void api_impl::handle_enable_done(
    const yplatform::task_context_ptr& ctx,
    future_void_t res,
    promise_void_t prom,
    const std::string& mdb,
    const std::string& suid,
    popid_t& id)
{
    if (res.has_exception())
    {
        TASK_LOG(ctx, error) << "api_impl::handle_enable_done exception: "
                             << get_exception_reason(res);
        prom.set_exception(storage_error());
    }
    else
    {
        handle_update(ctx, mdb, suid, id);
        prom.set(VoidResult());
    }
}

future_void_t api_impl::enable_abook(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    const popid_t& id)
{
    promise_void_t prom;
    future_void_t fres = dbInterface->enableAbook(ctx, suid, id);
    auto enableCallback =
        boost::bind(&api_impl::handle_enable_done, this, ctx, fres, prom, mdb, suid, id);
    fres.add_callback(enableCallback);
    return prom;
}

} // namespace yrpopper::api
