#include <api/api_impl.h>

namespace yrpopper::api {

future_void_t api_impl::remove(
    const yplatform::task_context_ptr& ctx,
    const std::string& mdb,
    const std::string& suid,
    const popid_t& id)
{
    promise_void_t prom;
    auto futureRemove = dbInterface->remove(ctx, suid, id);
    auto removeCallback =
        boost::bind(&api_impl::handle_remove_done, this, ctx, prom, futureRemove, mdb, suid, id);
    futureRemove.add_callback(removeCallback);
    return prom;
}

void api_impl::handle_remove_done(
    const yplatform::task_context_ptr& ctx,
    promise_void_t prom,
    future_void_t res,
    const std::string& mdb,
    const std::string& suid,
    const popid_t& id)
{
    if (res.has_exception())
    {
        TASK_LOG(ctx, error) << "api_impl::handle_remove_done exception:"
                             << get_exception_reason(res);
        prom.set_exception(storage_error());
    }
    else
    {
        handle_update(ctx, mdb, suid, id);
        prom.set(VoidResult());
    }
}

} // namespace yrpopper::api
