#pragma once

#include <api/error.h>

#include <ymod_imapclient/errors.h>

namespace yrpopper { namespace api {

inline void ensure_allowed_ip(
    const std::string& ip,
    settings_ptr settings,
    yplatform::task_context_ptr ctx)
{
    bool in_yandex_net = settings->yandex_nets.contains(ip);
    bool allowed_ip = settings->allowed_ip.find(ip) != settings->allowed_ip.end();
    if (in_yandex_net && !allowed_ip)
    {
        LERR_(ctx) << "access denied: yandex ip (" << ip
                   << ") is not listed on the allowed ip list";
        throw access_denied_error();
    }
}

} // namespace api
} // namespace yrpopper
