#pragma once

#include <api/api_impl.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace yrpopper { namespace api {

struct update_failed_auth_counter_op : std::enable_shared_from_this<update_failed_auth_counter_op>
{
    using yield_context = yplatform::yield_context<update_failed_auth_counter_op>;

    promise_void_t res;
    connect_args args;
    rc_options options;

    boost::system::error_code ec;
    boost::asio::ip::udp::endpoint endpoint;

    update_failed_auth_counter_op(const connect_args& args, const rc_options& options)
        : args(args), options(options)
    {
    }

    future_void_t run()
    {
        yplatform::spawn(yplatform::shared_from(this));
        return res;
    }

    void operator()(yield_context yield_ctx)
    {
        reenter(yield_ctx)
        {
            if (args.rc_email)
            {
                LINFO_(args.ctx) << "pop.rc quota left for email: "
                                 << options.max_email_count - args.rc_email->info().counter;
                yield args.rc_email->mark(args.ctx->uniq_id(), yield_ctx.capture(ec, endpoint));
                if (ec)
                {
                    LERR_(args.ctx) << "pop.rc mark error for email: " << ec.message()
                                    << ", host: " << endpoint;
                }
            }
            if (args.rc_ip)
            {
                LINFO_(args.ctx) << "pop.rc quota left for ip: "
                                 << options.max_ip_count - args.rc_ip->info().counter;
                yield args.rc_ip->mark(args.ctx->uniq_id(), yield_ctx.capture(ec, endpoint));
                if (ec)
                {
                    LERR_(args.ctx)
                        << "pop.rc mark error for ip: " << ec.message() << ", host: " << endpoint;
                }
            }
            res.set({});
        }
    }

    void operator()(yield_context::exception_type exception)
    {
        LERR_(args.ctx) << "exception during update_failed_auth_counter_op occured: "
                        << get_exception_reason(exception);
        // If rc server down - ignore error
        res.set({});
    }
};

} // namespace api
} // namespace yrpopper

#include <yplatform/unyield.h>
