#include "basic_rc_client.h"
#include <boost/functional/hash.hpp>
#include <boost/thread.hpp>
#include <sys/types.h> // for getpid

class basic_rc_category_t : public boost::system::error_category
{
public:
    const char* name() const noexcept override
    {
        return "nwsmtp.basic_rc";
    }

    std::string message(int value) const override
    {
        if (value == bad_response_id) return "Bad rcsrv reponse ID";
        if (value == bad_response) return "Bad rcsrv response";
        return "nwsmtp.basic_rc error";
    }
};

const boost::system::error_category& get_basic_rc_category()
{
    static basic_rc_category_t instance;
    return instance;
}

std::size_t basic_rc_request_id_gen(std::size_t seed)
{
    boost::hash_combine(seed, time(0));
    boost::hash_combine(seed, ::getpid());
    boost::hash_combine(seed, boost::lexical_cast<std::string>(boost::this_thread::get_id()));
    return seed;
}
