#pragma once

#include <optional>
#include <set>
#include <common/util.h>
#include <common/config.h>
#include <common/ip_nets.h>
#include <api/rc/rc_options.h>
#include <ymod_httpclient/call.h>

namespace yrpopper { namespace api {

struct connect_param
{
    string server;
    uint32_t port;
    bool use_ssl;
};

struct server_param
{
    bool use_imap;
    connect_param recieve;
    connect_param send;
};

typedef std::map<string, server_param> domain_settings;

struct OAuthHackSettings
{
    bool validate_email;
};

struct ApiSettings
{
    string my_owner_name;
    yrpopper::common::ip_nets yandex_nets;
    std::set<string> yandex_hosts;
    std::set<string> allowed_ip;
    bool log_extra;
    rc_options rc;
    bool use_rc;
    bool use_cache;
    versioned_keys_t dkeys;
    string my_ip_addr;
    domain_settings predefined_settings;

    string secret;

    string furita_host;
    int furita_retries;

    unsigned sid;

    bool useFurita;

    typedef std::pair<std::string, bool> oauthInfo;
    std::vector<oauthInfo> oauth2Workaround; // 12.11.2015 дублирующий функционал, вынести в
                                             // процесор всё что связано с работой с сервером

    std::vector<string> forbidden_pop3_messages;
    std::vector<string> forbidden_imap_names;

    std::optional<OAuthHackSettings> oauth_hack_settings;
};

typedef boost::shared_ptr<ApiSettings> settings_ptr;

}}
