#pragma once

#include <common/config.h>
#include <api/settings.h>

#include <yplatform/future/future.hpp>
#include <yplatform/task_context.h>

#include <string>
#include <memory>

namespace yrpopper { namespace api {

struct SuidMdb
{
    std::string suid;
    std::string mdb;
};

typedef std::shared_ptr<SuidMdb> SuidMdbPtr;
typedef yplatform::future::future<SuidMdbPtr> FutureSuidMdb;
typedef yplatform::future::future<std::string> FutureStringResult;

FutureSuidMdb getSuidMdb(
    yplatform::task_context_ptr ctx,
    std::string uid,
    const ApiSettings& settings);
FutureBoolResult isPddUser(
    yplatform::task_context_ptr ctx,
    std::string email,
    const ApiSettings& settings);
FutureBoolResult compareUsers(
    yplatform::task_context_ptr ctx,
    std::string suid,
    std::string email,
    const ApiSettings& settings);
FutureStringResult getSuid(
    yplatform::task_context_ptr ctx,
    std::string email,
    const ApiSettings& settings);

} // namespace api
} // namespace yrpopper
