#pragma once

#include <memory>

#include <collector_ng/collector_session.h>
#include <collector_ng/collector_settings.h>
#include <common/context.h>

#include <ymod_blackbox/auth.h>

namespace yrpopper { namespace collector {

struct StepResult
{
    error error = code::ok;

    uint32_t badRetries = 0;
    uint32_t messageCount = 0;
    bool validated = true;

    std::time_t startTime = std::time(0);
};
typedef std::shared_ptr<StepResult> StepResultPtr;

typedef yplatform::future::future<StepResultPtr> FutureStepResultPtr;
typedef yplatform::future::promise<StepResultPtr> PromiseStepResultPtr;

typedef yplatform::future::future<ymod_blackbox::response> FutureAuthResponse;

class Collector
{
public:
    virtual ~Collector()
    {
    }

    virtual FutureStepResultPtr step() = 0;
    virtual void stop() = 0;

    virtual rpop_context_ptr getContext() = 0;
    virtual void updateContext(rpop_context_ptr context) = 0;
};

class CollectorImpl
    : public Collector
    , public std::enable_shared_from_this<CollectorImpl>
{
public:
    CollectorImpl(
        rpop_context_ptr context,
        CollectorSessionPtr session,
        CollectorSettingsPtr settings)
        : context(context)
        , session(session)
        , settings(settings)
        , inited(false)
        , inProgress(false){};

    ~CollectorImpl(){};

    FutureStepResultPtr step() override;
    void stop() override;

    rpop_context_ptr getContext() override;
    void updateContext(rpop_context_ptr context) override;

private:
    void finishStep(std::exception_ptr e);
    void fullfillPromise();

    void init();
    void updateBlackbox();
    void collect();

    void handleInit(std::exception_ptr e);
    void handleBlackbox(FutureAuthResponse bbInfoRes);
    void handleCollect(std::exception_ptr e);

private:
    rpop_context_ptr context;
    CollectorSessionPtr session;
    CollectorSettingsPtr settings;

    PromiseStepResultPtr currentRes;

    bool inited;
    std::atomic_bool inProgress;

    StepResultPtr stepResult;
};

typedef std::shared_ptr<Collector> CollectorPtr;

} /* namespace collector */ } /* namespace yrpopper */
