#pragma once

#include <stdexcept>
#include <string>

namespace yrpopper { namespace collector {

// General collector errors

struct CollectorError : public std::runtime_error
{
    CollectorError(const std::string& message) : std::runtime_error(message)
    {
    }
};

struct NoSessionError : public CollectorError
{
    NoSessionError() : CollectorError("")
    {
    }
};

struct BlackboxError : public CollectorError
{
    BlackboxError() : CollectorError("")
    {
    }
};

struct KarmaError : public CollectorError
{
    KarmaError() : CollectorError("")
    {
    }
};

struct ResolveError : public CollectorError
{
    ResolveError(const std::string& message) : CollectorError(message)
    {
    }
};

struct ConnectError : public CollectorError
{
    ConnectError(const std::string& message) : CollectorError(message)
    {
    }
};

struct SslError : public CollectorError
{
    SslError(const std::string& message) : CollectorError(message)
    {
    }
};

struct AuthError : public CollectorError
{
    AuthError(const std::string& message) : CollectorError(message)
    {
    }
};

struct DbError : public CollectorError
{
    DbError(const std::string& message) : CollectorError(message)
    {
    }
};

struct TransportError : public CollectorError
{
    TransportError(const std::string& message) : CollectorError(message)
    {
    }
};

struct TimeoutError : public CollectorError
{
    TimeoutError(const std::string& message) : CollectorError(message)
    {
    }
};

// Internal collectors error

struct InternalCollectorError : public CollectorError
{
    InternalCollectorError(const std::string& message) : CollectorError(message)
    {
    }
};

struct NoSuchMessageError : public InternalCollectorError
{
    NoSuchMessageError(const std::string& message) : InternalCollectorError(message)
    {
    }
};

struct EmptyHelperError : public InternalCollectorError
{
    EmptyHelperError(const std::string& message) : InternalCollectorError(message)
    {
    }
};

} /* namespace collector */ } /* namespace yrpopper */
