#include <collector_ng/collector_service.h>
#include <collector_ng/imap/collector_session_imap.h>
#include <collector_ng/http/collector_session_ms365_http.h>

#include <oauth/hack/util.h>

namespace yrpopper::collector {

void CollectorService::init(const yplatform::ptree& xml)
{
    L_(debug) << "activating collector::CollectorService";

    settings->update(xml);
    if (settings->httpCollectorsEnabled)
    {
        httpCollectorsReactor = std::make_shared<yplatform::reactor>();
        httpCollectorsReactor->init(1, settings->httpCollector.threads);
        httpCollectorsReactor->run();
    }
}

void CollectorService::reload(const yplatform::ptree& xml)
{
    settings->update(xml);
}

void CollectorService::fini()
{
    if (httpCollectorsReactor)
    {
        httpCollectorsReactor->stop();
        httpCollectorsReactor->fini();
    }
}

std::shared_ptr<Collector> CollectorService::getCollector(rpop_context_ptr context)
{
    Locker lock(mutex);
    if (collectors.count(context->task->popid))
    {
        auto collector = collectors.at(context->task->popid);
        collector->updateContext(context);
        return collector;
    }

    CollectorSessionPtr session;
    if (context->task->use_imap)
    {
        if (httpCollectorsReactor && context->task->server == oauth::hack::OUTLOOK_IMAP_SERVER &&
            !context->task->oauth_refresh_token.empty())
        {
            L_(debug) << "CollectorService::getCollector init CollectorSessionMS365Http";

            session = std::make_shared<CollectorSessionMS365Http>(
                context, *httpCollectorsReactor->io(), settings);
        }
        else
        {
            session = std::make_shared<CollectorSessionImap>(context, settings);
        }
    }
    else
    {
        // session = std::make_shared<CollectorSessionPop3>(context, ioService);
    }

    auto res = std::make_shared<CollectorImpl>(context, session, settings);
    collectors.insert(std::make_pair(context->task->popid, res));

    return res;
}

void CollectorService::killCollector(popid_t popid)
{
    Locker lock(mutex);
    auto collectorIt = collectors.find(popid);
    if (collectorIt != collectors.end())
    {
        collectors.erase(collectorIt);
    }
}

} // namespace yrpopper::collector

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(yrpopper::collector::CollectorService)
