#pragma once

#include <mutex>

#include <collector_ng/collector.h>
#include <collector_ng/collector_settings.h>
#include <common/context.h>

#include <yplatform/module.h>
#include <yplatform/reactor.h>

namespace yrpopper { namespace collector {

class CollectorService
    : public yplatform::module
    , public boost::noncopyable
{
    typedef std::lock_guard<std::mutex> Locker;

public:
    CollectorService() : settings(std::make_shared<CollectorSettings>())
    {
        L_(debug) << "collector::CollectorService instaniated";
    }

    virtual ~CollectorService()
    {
        L_(debug) << "collector::CollectorService destroyed";
    }

    void init(const yplatform::ptree& xml);
    void reload(const yplatform::ptree& xml);
    void fini();

    virtual CollectorPtr getCollector(rpop_context_ptr context);
    virtual void killCollector(popid_t popid);

private:
    std::mutex mutex;
    CollectorSettingsPtr settings;
    std::map<popid_t, CollectorPtr> collectors;
    std::shared_ptr<yplatform::reactor> httpCollectorsReactor;
};

} /* namespace collector */ } /* namespace yrpopper */
