#pragma once

#include <memory>
#include <common/context.h>
#include <common/task.h>
#include <common/async/operation.h>
#include <yplatform/future/future.hpp>

namespace yrpopper { namespace collector {

class CollectorSession
{
public:
    virtual ~CollectorSession(){};

    virtual void init(AsyncCallback) = 0;
    virtual void collect(AsyncCallback) = 0;
    virtual void stop() = 0;

    virtual void updateBlackboxInfo(const blackbox_task_info& bbInfo) = 0;
    virtual void updateContext(rpop_context_ptr context) = 0;
};

typedef std::shared_ptr<CollectorSession> CollectorSessionPtr;

} /* namespace collector */ } /* namespace yrpopper */
