#pragma once

#include <common/http_loader.h>
#include <common/context.h>

namespace yrpopper { namespace collector {

class EmailValidator : public XmlHttpLoader<HttpGet>
{
public:
    EmailValidator(rpop_context_ptr context, std::string host, size_t maxRetries)
        : XmlHttpLoader(context, host, maxRetries)
        , uid(context->task->bb_info.getUid())
        , email(context->task->email)
    {
    }

    virtual ~EmailValidator()
    {
    }

    FutureBoolResult validate()
    {
        this->load();
        return prom;
    }

protected:
    virtual void handleXml(boost::property_tree::ptree&& xmlPtree)
    {
        auto tag = xmlPtree.get_child_optional("page.validator-rpop-added");
        if (tag)
        {
            TASK_LOG(context, info) << "validate: status=ok";
            prom.set(true);
        }
        else
        {
            auto description = data.str().substr(0, 200);
            handleError(description);
        }
    }

    virtual void handleError(const std::string& errorMessage)
    {
        TASK_LOG(context, error) << "validate: status=error (" << errorMessage << ")";
        prom.set(false);
    }

    virtual std::string getRequestData()
    {
        std::ostringstream request;
        request << "?op=addrpop&uid=" << uid << "&email=" << email;
        return request.str();
    }

protected:
    PromiseBoolResult prom;

    std::string uid;
    std::string email;
};
typedef boost::shared_ptr<EmailValidator> EmailValidatorPtr;

} // namespace collector
} // namespace yrpopper
