#include <collector_ng/http/collector_session_ms365_http.h>
#include <collector_ng/http/ms365_collect_op.h>
#include <oauth/oauth.h>
#include <ymod_httpclient/url_encode.h>
#include <yplatform/find.h>

#include <boost/format.hpp>
#include <exception>

namespace yrpopper::collector {

void CollectorSessionMS365Http::init(AsyncCallback cb)
{
    cb(nullptr);
}

void CollectorSessionMS365Http::collect(AsyncCallback cb)
{
    ioService.post([this, cb, self = shared_from_this()]() {
        try
        {
            auto op = std::make_shared<operations::MS365CollectOp<>>(getContext(), getSettings());
            op->execute();
            cb(nullptr);
        }
        catch (const std::exception& e)
        {
            cb(std::current_exception());
        }
    });
}

void CollectorSessionMS365Http::stop()
{
}

void CollectorSessionMS365Http::updateBlackboxInfo(const blackbox_task_info& bbInfo)
{
    collectorCtx->task->bb_info.update(bbInfo);
}

} // namespace yrpopper::collector
