#pragma once

#include <collector_ng/collector_session.h>
#include <collector_ng/collector_settings.h>
#include <db/interface_provider.h>
#include <boost/asio/strand.hpp>

namespace yrpopper::collector {

class CollectorSessionMS365Http
    : public std::enable_shared_from_this<CollectorSessionMS365Http>
    , public CollectorSession
{
public:
    CollectorSessionMS365Http(
        rpop_context_ptr context,
        boost::asio::io_service& ioService,
        CollectorSettingsPtr settings)
        : ioService(ioService), collectorCtx(context), settings(*settings)
    {
    }

    virtual ~CollectorSessionMS365Http(){};

    virtual void init(AsyncCallback cb) override;
    virtual void collect(AsyncCallback cb) override;
    virtual void stop() override;

    virtual void updateBlackboxInfo(const blackbox_task_info& bbInfo) override;

    void updateContext(rpop_context_ptr context) override
    {
        collectorCtx = context;
    }

    const CollectorSettings& getSettings()
    {
        return settings;
    }

    rpop_context_ptr getContext()
    {
        return collectorCtx;
    }

private:
    boost::asio::io_service& ioService;
    rpop_context_ptr collectorCtx;
    const CollectorSettings& settings;
};

}
