#include <ctime>
#include <string>

namespace yrpopper::collector {

inline std::string datetime_to_string(std::time_t raw_ts)
{
    char str[100];
    auto res = std::strftime(str, sizeof(str), "%Y-%m-%dT%H:%M:%SZ", std::gmtime(&raw_ts));
    if (!res)
    {
        throw std::runtime_error("failed to convert datetime to string");
    }
    return str;
}

inline std::time_t string_to_datetime(const std::string& str)
{
    tm tm{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    auto res = strptime(str.c_str(), "%Y-%m-%dT%H:%M:%SZ", &tm);
    if (!res)
    {
        throw std::runtime_error("failed to parse datetime from string");
    }
    return timegm(&tm);
}

}
