#include <collector_ng/imap/collector_session_imap.h>
#include <collector_ng/imap/operations/imap_init_operations.h>
#include <collector_ng/imap/operations/imap_collect_operations.h>

namespace yrpopper::collector {

void CollectorSessionImap::init(AsyncCallback cb)
{
    runAsync<operations::ImapInit>(cb, collectorHelper);
}

void CollectorSessionImap::collect(AsyncCallback cb)
{
    collectorHelper->getContext()->sent_count = 0;
    runAsync<operations::ImapCollect>(cb, collectorHelper);
}

void CollectorSessionImap::stop()
{
    auto context = collectorHelper->getContext();
    collectorHelper->setReady(false);
    auto imapClientModule = yplatform::find<ymod_imap_client::call>("imap_client");
    collectorHelper->setImapClient(imapClientModule->clientInstance(context));
}

void CollectorSessionImap::updateBlackboxInfo(const blackbox_task_info& bbInfo)
{
    collectorHelper->getContext()->task->bb_info.update(bbInfo);
}

void CollectorSessionImap::updateContext(rpop_context_ptr context)
{
    collectorHelper->updateContext(context);
}

} // namespace yrpopper::collector
