#pragma once

#include <collector_ng/collector_session.h>

#include <collector_ng/imap/helpers/imap_helper.h>

#include <ymod_imapclient/call.h>
#include <yplatform/find.h>

namespace yrpopper { namespace collector {

class CollectorHelper : public ImapHelper
{
public:
    CollectorHelper(
        rpop_context_ptr context,
        CollectorSettingsPtr settings,
        ImapFolderListPtr imapFolderList)
        : ImapHelper(context, settings, imapFolderList)
    {
    }

    bool isReady()
    {
        return ready;
    }
    void setReady(bool ready)
    {
        this->ready = ready;
    }

    // ymod_imap_client::ImapMailboxList getFolderList() { return folderList; }
    // void setFolderList(ymod_imap_client::ImapMailboxList folderList) { this->folderList =
    // folderList; }

    void refreshImapClient()
    {
        auto imapClientModule = yplatform::find<ymod_imap_client::call>("imap_client");
        setImapClient(imapClientModule->clientInstance(context));
    }

private:
    bool ready = false;

    // ymod_imap_client::ImapMailboxList folderList;
};
typedef std::shared_ptr<CollectorHelper> CollectorHelperPtr;

class CollectorSessionImap
    : public std::enable_shared_from_this<CollectorSessionImap>
    , public CollectorSession
{
public:
    CollectorSessionImap(
        rpop_context_ptr context,
        CollectorSettingsPtr settings)
    {
        auto imapFolderList = ImapFolderList::get(context, settings);

        collectorHelper =
            std::make_shared<CollectorHelper>(context, settings, imapFolderList);
    }

    virtual ~CollectorSessionImap(){};

    virtual void init(AsyncCallback cb) override;
    virtual void collect(AsyncCallback cb) override;
    virtual void stop() override;

    virtual void updateBlackboxInfo(const blackbox_task_info& bbInfo) override;
    virtual void updateContext(rpop_context_ptr context) override;

private:
    CollectorHelperPtr collectorHelper;
};

} /* namespace collector */ } /* namespace yrpopper */
