#pragma once

#include <collector_ng/imap/helpers/imap_helper.h>

namespace yrpopper { namespace collector {

class ImapCollectFoldersHelper : public ImapHelper
{
public:
    ImapCollectFoldersHelper(
        const ImapHelper& baseHelper,
        const ymod_imap_client::ImapMailboxList& serverMailboxList)
        : ImapHelper(baseHelper), serverMailboxList(serverMailboxList)
    {
    }

    ymod_imap_client::ImapListItemPtr getCurrentMailbox() const
    {
        return serverMailboxList.back();
    }
    bool hasMoreMailboxes()
    {
        return !serverMailboxList.empty();
    }
    void nextMailbox()
    {
        if (hasMoreMailboxes())
        {
            serverMailboxList.pop_back();
        }
        else
        {
            throw EmptyHelperError("No more mailboxes in ImapListHelper");
        }
    }

    ymod_imap_client::ImapMailboxResultPtr getCurrentMailboxStats() const
    {
        return mailboxStats;
    }
    void setCurrentMailboxStats(ymod_imap_client::ImapMailboxResultPtr stats)
    {
        mailboxStats = stats;
    }

    ImapFolderPtr getImapFolder() const
    {
        return folder;
    }
    void setImapFolder(ImapFolderPtr nextFolder)
    {
        this->folder = nextFolder;
    }

private:
    ymod_imap_client::ImapMailboxList serverMailboxList;
    ymod_imap_client::ImapMailboxResultPtr mailboxStats;

    ImapFolderPtr folder;
};

typedef std::shared_ptr<ImapCollectFoldersHelper> ImapCollectFoldersHelperPtr;

} // namespace collector
} // namespace yrpopper
