#pragma once

#include <collector_ng/imap/helpers/imap_helper.h>
#include <ymod_imapclient/imap_result.h>

namespace yrpopper { namespace collector {

class ImapFolderHelper : public ImapHelper
{
public:
    ImapFolderHelper(
        const ImapHelper& baseHelper,
        ImapFolderPtr folder,
        ymod_imap_client::ImapMailboxResultPtr mailboxStats)
        : ImapHelper(baseHelper), imapFolder(folder), mailboxStats(mailboxStats)
    {
    }

    ImapFolderPtr getImapFolder() const
    {
        return imapFolder;
    }
    ymod_imap_client::ImapMailboxResultPtr getMailboxStats() const
    {
        return mailboxStats;
    }

    const std::vector<int64_t>& getChunk() const
    {
        return chunk;
    }
    void setChunk(std::vector<int64_t>&& res)
    {
        chunk = std::move(res);
    }

private:
    ImapFolderPtr imapFolder;
    ymod_imap_client::ImapMailboxResultPtr mailboxStats;

    std::vector<int64_t> chunk;
};

typedef std::shared_ptr<ImapFolderHelper> ImapFolderHelperPtr;

} // namespace collector
} // namespace yrpopper
