#pragma once

#include <memory>

#include <common/context.h>
#include <collector_ng/collector_settings.h>
#include <ymod_imapclient/imap_client.h>
#include <collector_ng/imap/imap_folders.h>

#include <yplatform/log.h>

namespace yrpopper { namespace collector {

using ymod_imap_client::ImapClientPtr;

class ImapServerInfo
{
public:
    bool canStarttls() const
    {
        return starttls;
    }
    void setStarttls(bool val)
    {
        starttls = val;
    }

    bool canId() const
    {
        return id;
    }
    void setId(bool val)
    {
        id = val;
    }

    bool canAuthPlain() const
    {
        return authPlain;
    }
    void setAuthPlain(bool val)
    {
        authPlain = val;
    }

    bool isGmail() const
    {
        return gmail;
    }
    void setGmail(bool val)
    {
        gmail = val;
    }

    ymod_imap_client::ImapClient::OauthLoginType getOauthLoginType() const
    {
        return oauthLoginType;
    }
    void setOauthLoginType(ymod_imap_client::ImapClient::OauthLoginType val)
    {
        oauthLoginType = val;
    }

private:
    bool starttls = false;
    bool id = false;
    bool authPlain = false;
    ymod_imap_client::ImapClient::OauthLoginType oauthLoginType =
        ymod_imap_client::ImapClient::Multiline;
    bool gmail = false;
};
typedef std::shared_ptr<ImapServerInfo> ImapServerInfoPtr;

class ImapHelper
{
public:
    ImapHelper(
        rpop_context_ptr context,
        CollectorSettingsPtr settings,
        ImapFolderListPtr imapFolderList)
        : context(context)
        , settings(*settings)
        , imapFolderList(imapFolderList)
        , serverInfo(std::make_shared<ImapServerInfo>())
    {
    }

    rpop_context_ptr getContext() const
    {
        return context;
    }

    void updateContext(rpop_context_ptr context)
    {
        this->context = context;
    }

    ymod_imap_client::ImapClientPtr getImapClient() const
    {
        return imapClient;
    }

    const CollectorSettings& getSettings() const
    {
        return settings;
    }

    ImapFolderListPtr getImapFolderList() const
    {
        return imapFolderList;
    }

    ImapServerInfoPtr getServerInfo() const
    {
        return serverInfo;
    }

    void setImapClient(ImapClientPtr imapClient)
    {
        this->imapClient = imapClient;
    }

protected:
    rpop_context_ptr context;
    ymod_imap_client::ImapClientPtr imapClient;
    const CollectorSettings& settings;

    ImapFolderListPtr imapFolderList;

    ImapServerInfoPtr serverInfo;
};

typedef std::shared_ptr<ImapHelper> ImapHelperPtr;

} // namespace collector
} // namespace yrpopper
