#pragma once

#include <collector_ng/imap/helpers/imap_helper.h>

namespace yrpopper { namespace collector {

class ImapListHelper : public ImapHelper
{
public:
    ImapListHelper(const ImapHelper& baseHelper) : ImapHelper(baseHelper)
    {
    }

    void setServerMailboxList(ymod_imap_client::ImapMailboxList&& list)
    {
        serverMailboxList = std::move(list);
    }
    const ymod_imap_client::ImapMailboxList& getServerMailboxList() const
    {
        return serverMailboxList;
    }

private:
    ymod_imap_client::ImapMailboxList serverMailboxList;
    ymod_imap_client::ImapMailboxResultPtr mailboxStats;

    ImapFolderPtr folder;
};

typedef std::shared_ptr<ImapListHelper> ImapListHelperPtr;

} // namespace collector
} // namespace yrpopper
