#pragma once

#include <boost/asio/strand.hpp>

#include <common/context.h>

#include <ymod_imapclient/imap_client.h>
#include <yplatform/find.h>
#include <processor_ng/processor_service.h>

#include <collector_ng/imap/helpers/imap_helper.h>
#include <collector_ng/collector_settings.h>

namespace yrpopper { namespace collector {

class ImapMessageHelper : public ImapHelper
{
public:
    ImapMessageHelper(
        const ImapHelper& baseHelper,
        ImapFolderPtr folder,
        ImapFolder::MessageState state)
        : ImapHelper(baseHelper), messageFolder(folder), messageState(state)
    {
    }

    ImapFolderPtr getMessageFolder() const
    {
        return messageFolder;
    }

    void setMessages(std::deque<uint32_t>&& messages)
    {
        this->messages = std::move(messages);
    }
    uint32_t getCurrentMessage() const
    {
        return messages.front();
    }
    bool hasMoreMessages()
    {
        return !messages.empty();
    }
    void nextMessage()
    {
        if (hasMoreMessages())
        {
            messages.pop_front();
        }
        else
        {
            throw EmptyHelperError("No more messages in ImapMessageHelper");
        }
    }

    ImapFolder::MessageState getMessageState() const
    {
        return messageState;
    }

    std::exception_ptr getMessageProcessingError() const
    {
        return messageProcessingError;
    }

    void setMessageProcessingError(std::exception_ptr res)
    {
        messageProcessingError = res;
    }

    const processor::ProcessorResult& getMessageProcessingResult() const
    {
        return messageProcessingResult;
    }

    void setMessageProcessingResult(const processor::ProcessorResult& res)
    {
        messageProcessingResult = res;
    }

    processor::MessagePtr getProcessorMessage() const
    {
        return msg;
    }
    void setProcessorMessage(processor::MessagePtr msg)
    {
        this->msg = msg;
    }

private:
    ImapFolderPtr messageFolder;
    std::deque<uint32_t> messages;

    ImapFolder::MessageState messageState;
    std::exception_ptr messageProcessingError;
    processor::ProcessorResult messageProcessingResult;

    processor::MessagePtr msg;
};

typedef std::shared_ptr<ImapMessageHelper> ImapMessageHelperPtr;

} /* namespace collector */ } /* namespace yrpopper */
