#pragma once

#include <collector_ng/imap/helpers/imap_helper.h>

namespace yrpopper { namespace collector {

class ImapPreaparedFolderHelper : public ImapHelper
{
public:
    ImapPreaparedFolderHelper(const ImapHelper& baseHelper)
        : ImapHelper(baseHelper), preparedList(baseHelper.getImapFolderList()->getPrepared())
    {
    }

    ImapFolderPtr getCurrentFolder()
    {
        return preparedList.back();
    }
    bool hasMoreFolders()
    {
        return !preparedList.empty();
    }
    void nextFolder()
    {
        if (hasMoreFolders())
        {
            preparedList.pop_back();
        }
        else
        {
            throw EmptyHelperError("No more folders in ImapPreaparedFoldersHelper");
        }
    }

private:
    std::vector<ImapFolderPtr> preparedList;
};

typedef std::shared_ptr<ImapPreaparedFolderHelper> ImapPreaparedFolderHelperPtr;

} // namespace collector
} // namespace yrpopper
