#pragma once

#include <common/async/operation.h>
#include <common/async/conditional_operation.h>
#include <common/async/future_operation.h>
#include <common/async/complex_operation.h>
#include <common/async/cycle_operation.h>
#include <common/async/proxy_operation.h>

#include <ymod_imapclient/errors.h>
#include <ymod_imapclient/imap_result.h>

namespace yrpopper { namespace collector { namespace operations {

template <typename ImapOperation, typename OpHelperPtr>
class ImapOpBuilder
{
public:
    ImapOpBuilder(OpHelperPtr helper) : helper(helper)
    {
    }

    AsyncOperationPtr build(AsyncCallback cb)
    {
        return std::make_shared<ImapOperation>(cb, helper);
    }

private:
    OpHelperPtr helper;
};

template <typename OpHelperPtr, typename ResultType = ymod_imap_client::ImapResultPtr>
class GeneralImapOperation : public FutureOperation<ResultType>
{
public:
    GeneralImapOperation(AsyncCallback cb, OpHelperPtr helper)
        : FutureOperation<ResultType>(cb), helper(helper)
    {
    }

protected:
    virtual std::exception_ptr imapOnFinish(std::exception_ptr e)
    {
        return e;
    }

    virtual std::exception_ptr onFinish(std::exception_ptr e) override
    {
        if (e)
        {
            try
            {
                std::rethrow_exception(e);
            }
            catch (const ymod_imap_client::NoException& /*err*/)
            {
                return imapOnFinish(e);
            }
            catch (const ymod_imap_client::BadException& /*err*/)
            {
                return imapOnFinish(e);
            }
            catch (const std::exception& /*err*/)
            { // not allowed to skip network or other internal-specific errors
                return e;
            }
        }
        return imapOnFinish(e);
    }

    OpHelperPtr helper;
};

} // namespace operations
} // namespace collector
} // namespace yrpopper
