#pragma once

#include <common/async/operation.h>

namespace yrpopper {

namespace {

template <typename Operation, typename... Args>
OperationRunner specialMakeRunner(Args... args)
{
    return makeRunner<Operation, Args&...>(args...);
}

}

class BaseConditionalOperation : public AsyncOperation
{
public:
    BaseConditionalOperation(AsyncCallback cb) : AsyncOperation(cb)
    {
    }

    virtual ~BaseConditionalOperation()
    {
    }

protected:
    virtual bool checkCondition() = 0;

    virtual void run()
    {
        if (!checkCondition())
        {
            finishOperation();
            return;
        }

        if (runOp)
        {
            runOp();
        }
    }

    void setRunOp(OperationRunner&& runner)
    {
        runOp = runner;
    }

    virtual void cleanup()
    {
        runOp = OperationRunner();
    }

private:
    OperationRunner runOp;
};

} // namespace yrpopper
