#pragma once

#include <common/async/operation.h>

namespace yrpopper {

template <typename OpHelper, template <typename> class OpBuilder, typename... AllOperations>
class ComplexOperation : public AsyncOperation
{
    typedef ComplexOperation<OpHelper, OpBuilder, AllOperations...> ThisClass;

public:
    ComplexOperation(AsyncCallback cb, OpHelper opHelper) : AsyncOperation(cb), opHelper(opHelper)
    {
    }

protected:
    virtual void run()
    {
        unpackOperations<AllOperations...>();
        runNextOp();
    }

private:
    void runNextOp()
    {
        if (operations.empty())
        {
            finishOperation();
            return;
        }

        auto op = operations.back();
        operations.pop_back();

        op->start();
    }

    void handleOpFinish(std::exception_ptr e)
    {
        if (e)
        {
            finishOperation(e);
            return;
        }

        runNextOp();
    }

    template <typename... Operations>
    typename std::enable_if<sizeof...(Operations) == 0>::type unpackOperations()
    {
    }

    template <typename Operation, typename... Operations>
    void unpackOperations()
    {
        unpackOperations<Operations...>();
        buildOperation<Operation>();
    }

    template <typename Operation>
    void buildOperation()
    {
        OpBuilder<Operation> builder(opHelper);

        auto self = sharedAs<ThisClass>();

        auto callback = [self](std::exception_ptr e) { self->handleOpFinish(e); };
        auto buildRes = builder.build(callback);

        operations.push_back(buildRes);
    }

    virtual void cleanup()
    {
        operations.clear();
    }

private:
    OpHelper opHelper;
    std::vector<AsyncOperationPtr> operations;
};

} // namespace yrpopper
