#pragma once

#include <common/async/base_conditional_operation.h>

namespace yrpopper {

template <typename Operation>
class ConditionalOperation : public BaseConditionalOperation
{
    typedef ConditionalOperation<Operation> ThisClass;

public:
    template <typename... Args>
    ConditionalOperation(AsyncCallback cb, Args&&... args) : BaseConditionalOperation(cb)
    {
        // No perfect forwarding in this case
        // Our compiler isn't c++11 enough to do this:

        // makeRunner = [=](AsyncCallback callback) -> OperationRunner {
        //        return std::bind(&runAsync<IterationOp, AsyncCallback, Args...>, callback,
        //        std::forward<Args>(args)...);
        //};

        // std::bind can't bind with perfect forwarding AND placeholder, so "special" version of
        // function used
        makeRunner = std::bind(
            &specialMakeRunner<Operation, AsyncCallback, Args...>, std::placeholders::_1, args...);
    }

    virtual void start()
    {
        auto self = AsyncOperation::sharedAs<ThisClass>();
        auto callback = [self](std::exception_ptr e) { self->finishOperation(e); };

        this->setRunOp(makeRunner(callback));
        this->run();
    }

private:
    std::function<OperationRunner(AsyncCallback)> makeRunner;
};

} // namespace yrpopper
