#pragma once

#include <common/async/base_conditional_operation.h>

namespace yrpopper {

template <typename IterationOp>
class CycleOperation : public BaseConditionalOperation
{
    typedef CycleOperation<IterationOp> ThisClass;

public:
    template <typename... Args>
    CycleOperation(AsyncCallback cb, Args&&... args) : BaseConditionalOperation(cb)
    {
        // No perfect forwarding in this case
        // Our compiler isn't c++11 enough to do this:

        // makeRunner = [=](AsyncCallback callback) -> OperationRunner {
        //        return std::bind(&runAsync<IterationOp, AsyncCallback, Args...>, callback,
        //        std::forward<Args>(args)...);
        //};

        // std::bind can't bind with perfect forwarding AND placeholder, so "special" version of
        // function used
        makeRunner = std::bind(
            &specialMakeRunner<IterationOp, AsyncCallback, Args...>,
            std::placeholders::_1,
            args...);
    }

    virtual ~CycleOperation()
    {
    }

    virtual void start()
    {
        auto self = AsyncOperation::sharedAs<ThisClass>();
        auto iterationCallback = [self](std::exception_ptr e) { self->handleIterationFinish(e); };

        this->setRunOp(makeRunner(iterationCallback));
        this->run();
    }

private:
    void handleIterationFinish(std::exception_ptr e)
    {
        if (e)
        {
            this->finishOperation(e);
            return;
        }

        this->run();
    }

private:
    std::function<OperationRunner(AsyncCallback)> makeRunner;
};

} // namespace yrpopper
