#pragma once

#include <yplatform/future/future.hpp>

namespace yrpopper {

template <typename ResultType>
class FutureOperation : public AsyncOperation
{
    typedef FutureOperation<ResultType> ThisClass;

protected:
    typedef yplatform::future::future<ResultType> FutureType;

public:
    FutureOperation(AsyncCallback cb) : AsyncOperation(cb)
    {
    }

    virtual ~FutureOperation()
    {
    }

protected:
    virtual void run()
    {
        auto future = getFuture();

        auto self = sharedAs<ThisClass>();
        auto callback = [self, future]() { self->futureHandler(future); };
        future.add_callback(callback);
    }

    virtual FutureType getFuture() = 0;
    virtual void process(ResultType&& /*res*/){};

    virtual void futureHandler(FutureType future)
    {
        try
        {
            process(future.get());
            this->finishOperation();
        }
        catch (...)
        {
            this->finishOperation(std::current_exception());
        }
    }
};

} // namespace yrpopper
