#pragma once

#include <common/async/operation.h>

namespace yrpopper {

template <typename Operation>
class ProxyOperation : public AsyncOperation
{
    typedef ProxyOperation<Operation> ThisClass;

public:
    ProxyOperation(AsyncCallback cb) : AsyncOperation(cb)
    {
    }

    virtual ~ProxyOperation()
    {
    }

    template <typename... Args>
    void initProxy(Args&&... args)
    {
        auto self = sharedAs<ThisClass>();
        auto callback = [self](std::exception_ptr e) { self->finishOperation(e); };
        runOp = yrpopper::makeRunner<Operation>(callback, std::forward<Args>(args)...);
    }

protected:
    virtual void run()
    {
        if (runOp)
        {
            runOp();
        }
    }

    virtual void cleanup()
    {
        runOp = OperationRunner();
    }

    OperationRunner runOp;
};

} // namespace yrpopper
