#pragma once

#include <yplatform/future/future.hpp>
#include <yplatform/string_config.h>
#include <boost/shared_ptr.hpp>
#include <stdint.h>
#include <mutex>
#include <map>

namespace yrpopper {

using yplatform::string;

using std_lock = std::lock_guard<std::mutex>;

using namespace std::string_literals;

typedef std::shared_ptr<string> string_ptr;
typedef uint64_t popid_t;
typedef uint64_t actionid_t;

typedef std::list<actionid_t> action_list_t;
typedef std::map<uint64_t, std::string> chunk_requester_dict_t;
typedef boost::shared_ptr<chunk_requester_dict_t> chunk_requester_dict_ptr;

struct RpopActions
{
    popid_t popid;
    action_list_t actions;
};

typedef std::shared_ptr<RpopActions> RpopActionsPtr;
typedef std::vector<RpopActionsPtr> RpopActionsList;

template <typename T>
using Future = yplatform::future::future<T>;

template <typename T>
using Promise = yplatform::future::promise<T>;

typedef yplatform::future::future<RpopActionsList> FutureRpopActionsList;
typedef yplatform::future::promise<RpopActionsList> PromiseRpopActionsList;

typedef yplatform::future::future<string> future_string;
typedef yplatform::future::promise<string> promise_string;

typedef yplatform::future::future<bool> FutureBoolResult;
typedef yplatform::future::promise<bool> PromiseBoolResult;

typedef yplatform::future::future<uint> FutureUintResult;
typedef yplatform::future::promise<uint> PromiseUintResult;

struct mailbox_size
{
    mailbox_size() : limit(0), size(0)
    {
    }
    mailbox_size(std::size_t l, std::size_t s) : limit(l), size(s)
    {
    }
    std::size_t limit;
    std::size_t size;
};

struct VoidResult
{
};

typedef yplatform::future::future<VoidResult> FutureVoidResult;
typedef yplatform::future::promise<VoidResult> PromiseVoidResult;

}
