#pragma once

#include <common/task.h>
#include <common/uidl.h>
#include <common/config.h>
#include <yplatform/future/future.hpp>

namespace yrpopper {

typedef std::deque<task_info> task_info_list;
typedef boost::shared_ptr<task_info_list> task_info_list_ptr;
typedef yplatform::future::future<VoidResult> future_void_t;
typedef yplatform::future::promise<VoidResult> promise_void_t;
typedef yplatform::future::future<popid_t> future_popid_t;
typedef yplatform::future::promise<popid_t> promise_popid_t;
typedef yplatform::future::future<mailbox_size> future_mailbox_size;
typedef yplatform::future::promise<mailbox_size> promise_mailbox_size;
typedef yplatform::future::future<uidl_map_ptr> future_uidl_map;
typedef yplatform::future::promise<uidl_map_ptr> promise_uidl_map;
typedef yplatform::future::future<task_info_list_ptr> future_task_info_list;
typedef yplatform::future::promise<task_info_list_ptr> promise_task_info_list;
typedef yplatform::future::future<chunk_requester_dict_ptr> future_chunk_requester_dict;
typedef yplatform::future::promise<chunk_requester_dict_ptr> promise_chunk_requester_dict;
typedef yplatform::future::future<task_ptr_list_ptr> future_task_ptr_list;
typedef yplatform::future::promise<task_ptr_list_ptr> promise_task_ptr_list;
typedef yplatform::future::future<imap_folders_ptr> future_imap_folders;
typedef yplatform::future::future<http_folders_ptr> future_http_folders;
typedef yplatform::future::promise<http_folders_ptr> promise_http_folders;
typedef yplatform::future::promise<imap_folders_ptr> promise_imap_folders;
typedef yplatform::future::future<int> future_int_t;
typedef yplatform::future::promise<int> promise_int_t;
typedef yplatform::future::future<uint64_t> future_uint64_t;
typedef yplatform::future::promise<uint64_t> promise_uint64_t;
typedef yplatform::future::future<imap_uidl_map_ptr> future_imap_uidl_map;
typedef yplatform::future::promise<imap_uidl_map_ptr> promise_imap_uidl_map;
typedef yplatform::future::future<bool> future_bool_t;
typedef yplatform::future::promise<bool> promise_bool_t;
typedef yplatform::future::promise<std::exception_ptr> promise_exception_ptr;
typedef yplatform::future::future<std::exception_ptr> future_exception_ptr;

struct FolderStatus
{
    uint64_t folderId;
    std::string folderName;
    size_t messages;
    size_t collected;
    size_t errors;
};

using StatusData = std::vector<FolderStatus>;
typedef yplatform::future::future<StatusData> FutureStatusData;
typedef yplatform::future::promise<StatusData> PromiseStatusData;

}
