#pragma once

#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netdb.h>
#include <common/config.h>

namespace yrpopper {

namespace detail {

inline string sockaddr_2_string(const struct sockaddr* sa)
{
    char buf[128];
    switch (sa->sa_family)
    {
    case AF_INET:
        return inet_ntop(AF_INET, &(((struct sockaddr_in*)sa)->sin_addr), buf, sizeof(buf));
    case AF_INET6:
        return inet_ntop(AF_INET6, &(((struct sockaddr_in6*)sa)->sin6_addr), buf, sizeof(buf));
    default:
        return "";
    }
}

inline string get_proto_spec_ip(const string& host, int proto)
{
    addrinfo* res;
    addrinfo hints = { 0, proto, 0, 0, 0, 0, 0, 0 };
    string result;
    if (getaddrinfo(host.c_str(), 0, &hints, &res))
    {
        return result;
    }
    for (addrinfo* i = res; i; i = i->ai_next)
    {
        result = sockaddr_2_string(i->ai_addr);
        break;
    }
    freeaddrinfo(res);
    return result;
}

}

inline string get_my_hostname()
{
    char host_name[255];
    ::memset(host_name, 0, sizeof(host_name));
    if (::gethostname(host_name, sizeof(host_name)))
    {
        ::abort();
    }
    return string(host_name);
}

inline string get_my_ipaddr()
{
    string owner_name = get_my_hostname();
    string ip_addr = detail::get_proto_spec_ip(owner_name, AF_INET);
    if (ip_addr.empty()) ip_addr = detail::get_proto_spec_ip(owner_name, AF_INET6);
    if (ip_addr.empty()) ip_addr = "127.0.0.1";
    return ip_addr;
}

}
